import usePreferences from '../../../hooks/usePreferences';

export const taxCalculation = (data) => {
    const { preference: { decimal_digits } = {} } = usePreferences();
    let taxOptionArray = [];
    if (
        (data?.displayTax || data?.displayTaxTotal) === 'itemized' &&
        !Array.isArray(data?.tax) &&
        typeof data?.tax === 'object' &&
        Object.keys(data?.tax).length > 0
    ) {
        for (let item in data?.tax) {
            taxOptionArray.push({
                [item]: Number(data?.tax[item]).toFixed(Number(decimal_digits)),
            });
        }
    } else if (
        (data?.displayTax || data?.displayTaxTotal) === 'as a single total'
    ) {
        taxOptionArray.push({
            Tax: Number(data?.tax).toFixed(Number(decimal_digits)),
        });
    }
    return taxOptionArray;
};
